package zio.aws.ssoadmin.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{
  Date,
  UUId,
  PermissionSetArn,
  TargetId,
  PrincipalId,
  Reason
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class AccountAssignmentOperationStatus(
    createdDate: Optional[Date] = Optional.Absent,
    failureReason: Optional[Reason] = Optional.Absent,
    permissionSetArn: Optional[PermissionSetArn] = Optional.Absent,
    principalId: Optional[PrincipalId] = Optional.Absent,
    principalType: Optional[zio.aws.ssoadmin.model.PrincipalType] =
      Optional.Absent,
    requestId: Optional[UUId] = Optional.Absent,
    status: Optional[zio.aws.ssoadmin.model.StatusValues] = Optional.Absent,
    targetId: Optional[TargetId] = Optional.Absent,
    targetType: Optional[zio.aws.ssoadmin.model.TargetType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus = {
    import AccountAssignmentOperationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus
      .builder()
      .optionallyWith(createdDate.map(value => Date.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(
        failureReason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.failureReason)
      .optionallyWith(
        permissionSetArn.map(value =>
          PermissionSetArn.unwrap(value): java.lang.String
        )
      )(_.permissionSetArn)
      .optionallyWith(
        principalId.map(value => PrincipalId.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .optionallyWith(
        requestId.map(value => UUId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly =
    zio.aws.ssoadmin.model.AccountAssignmentOperationStatus
      .wrap(buildAwsValue())
}
object AccountAssignmentOperationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.AccountAssignmentOperationStatus =
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus(
        createdDate.map(value => value),
        failureReason.map(value => value),
        permissionSetArn.map(value => value),
        principalId.map(value => value),
        principalType.map(value => value),
        requestId.map(value => value),
        status.map(value => value),
        targetId.map(value => value),
        targetType.map(value => value)
      )
    def createdDate: Optional[Date]
    def failureReason: Optional[Reason]
    def permissionSetArn: Optional[PermissionSetArn]
    def principalId: Optional[PrincipalId]
    def principalType: Optional[zio.aws.ssoadmin.model.PrincipalType]
    def requestId: Optional[UUId]
    def status: Optional[zio.aws.ssoadmin.model.StatusValues]
    def targetId: Optional[TargetId]
    def targetType: Optional[zio.aws.ssoadmin.model.TargetType]
    def getCreatedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getFailureReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getPermissionSetArn: ZIO[Any, AwsError, PermissionSetArn] =
      AwsError.unwrapOptionField("permissionSetArn", permissionSetArn)
    def getPrincipalId: ZIO[Any, AwsError, PrincipalId] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getPrincipalType
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
    def getRequestId: ZIO[Any, AwsError, UUId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssoadmin.model.StatusValues] =
      AwsError.unwrapOptionField("status", status)
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getTargetType: ZIO[Any, AwsError, zio.aws.ssoadmin.model.TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus
  ) extends zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly {
    override val createdDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssoadmin.model.primitives.Date(value))
    override val failureReason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.ssoadmin.model.primitives.Reason(value))
    override val permissionSetArn: Optional[PermissionSetArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionSetArn())
        .map(value => zio.aws.ssoadmin.model.primitives.PermissionSetArn(value))
    override val principalId: Optional[PrincipalId] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => zio.aws.ssoadmin.model.primitives.PrincipalId(value))
    override val principalType: Optional[zio.aws.ssoadmin.model.PrincipalType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principalType())
        .map(value => zio.aws.ssoadmin.model.PrincipalType.wrap(value))
    override val requestId: Optional[UUId] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.ssoadmin.model.primitives.UUId(value))
    override val status: Optional[zio.aws.ssoadmin.model.StatusValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssoadmin.model.StatusValues.wrap(value))
    override val targetId: Optional[TargetId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetId())
      .map(value => zio.aws.ssoadmin.model.primitives.TargetId(value))
    override val targetType: Optional[zio.aws.ssoadmin.model.TargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetType())
        .map(value => zio.aws.ssoadmin.model.TargetType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus
  ): zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly =
    new Wrapper(impl)
}
