package zio.aws.ssoadmin.model
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{
  PermissionSetArn,
  Token,
  MaxResults,
  InstanceArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAccountsForProvisionedPermissionSetRequest(
    instanceArn: InstanceArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    permissionSetArn: PermissionSetArn,
    provisioningStatus: Optional[zio.aws.ssoadmin.model.ProvisioningStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest = {
    import ListAccountsForProvisionedPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .optionallyWith(provisioningStatus.map(value => value.unwrap))(
        _.provisioningStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
      .wrap(buildAwsValue())
}
object ListAccountsForProvisionedPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest =
      zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest(
        instanceArn,
        maxResults.map(value => value),
        nextToken.map(value => value),
        permissionSetArn,
        provisioningStatus.map(value => value)
      )
    def instanceArn: InstanceArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[Token]
    def permissionSetArn: PermissionSetArn
    def provisioningStatus: Optional[zio.aws.ssoadmin.model.ProvisioningStatus]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getProvisioningStatus
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.ProvisioningStatus] =
      AwsError.unwrapOptionField("provisioningStatus", provisioningStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssoadmin.model.primitives.MaxResults(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val provisioningStatus
        : Optional[zio.aws.ssoadmin.model.ProvisioningStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningStatus())
        .map(value => zio.aws.ssoadmin.model.ProvisioningStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
  ): zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
