package zio.aws.ssoadmin.model
import scala.jdk.CollectionConverters._
sealed trait PrincipalType {
  def unwrap: software.amazon.awssdk.services.ssoadmin.model.PrincipalType
}
object PrincipalType {
  def wrap(
      value: software.amazon.awssdk.services.ssoadmin.model.PrincipalType
  ): zio.aws.ssoadmin.model.PrincipalType = value match {
    case software.amazon.awssdk.services.ssoadmin.model.PrincipalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssoadmin.model.PrincipalType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.ssoadmin.model.PrincipalType.GROUP =>
      val r = GROUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssoadmin.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.PrincipalType =
      software.amazon.awssdk.services.ssoadmin.model.PrincipalType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.ssoadmin.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.PrincipalType =
      software.amazon.awssdk.services.ssoadmin.model.PrincipalType.USER
  }
  case object GROUP extends zio.aws.ssoadmin.model.PrincipalType {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.PrincipalType =
      software.amazon.awssdk.services.ssoadmin.model.PrincipalType.GROUP
  }
}
