package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{PermissionSetArn, InstanceArn}
import scala.jdk.CollectionConverters._
final case class DetachCustomerManagedPolicyReferenceFromPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    customerManagedPolicyReference: zio.aws.ssoadmin.model.CustomerManagedPolicyReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest = {
    import DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .customerManagedPolicyReference(
        customerManagedPolicyReference.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
      .wrap(buildAwsValue())
}
object DetachCustomerManagedPolicyReferenceFromPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest =
      zio.aws.ssoadmin.model
        .DetachCustomerManagedPolicyReferenceFromPermissionSetRequest(
          instanceArn,
          permissionSetArn,
          customerManagedPolicyReference.asEditable
        )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def customerManagedPolicyReference
        : zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getCustomerManagedPolicyReference: ZIO[
      Any,
      Nothing,
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    ] = ZIO.succeed(customerManagedPolicyReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val customerManagedPolicyReference
        : zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly =
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference
        .wrap(impl.customerManagedPolicyReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
  ): zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
