package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{PermissionSetArn, InstanceArn}
import scala.jdk.CollectionConverters._
final case class DeletePermissionsBoundaryFromPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest = {
    import DeletePermissionsBoundaryFromPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest
      .wrap(buildAwsValue())
}
object DeletePermissionsBoundaryFromPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest =
      zio.aws.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest(
        instanceArn,
        permissionSetArn
      )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest
  ): zio.aws.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
