package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{PermissionSetArn, InstanceArn}
import scala.jdk.CollectionConverters._
final case class DescribePermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest = {
    import DescribePermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.DescribePermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.DescribePermissionSetRequest.wrap(buildAwsValue())
}
object DescribePermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.DescribePermissionSetRequest =
      zio.aws.ssoadmin.model
        .DescribePermissionSetRequest(instanceArn, permissionSetArn)
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest
  ) extends zio.aws.ssoadmin.model.DescribePermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest
  ): zio.aws.ssoadmin.model.DescribePermissionSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
