package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{PermissionSetArn, InstanceArn}
import scala.jdk.CollectionConverters._
final case class PutPermissionsBoundaryToPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    permissionsBoundary: zio.aws.ssoadmin.model.PermissionsBoundary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest = {
    import PutPermissionsBoundaryToPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .permissionsBoundary(permissionsBoundary.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest
      .wrap(buildAwsValue())
}
object PutPermissionsBoundaryToPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest =
      zio.aws.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest(
        instanceArn,
        permissionSetArn,
        permissionsBoundary.asEditable
      )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def permissionsBoundary: zio.aws.ssoadmin.model.PermissionsBoundary.ReadOnly
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getPermissionsBoundary: ZIO[
      Any,
      Nothing,
      zio.aws.ssoadmin.model.PermissionsBoundary.ReadOnly
    ] = ZIO.succeed(permissionsBoundary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val permissionsBoundary
        : zio.aws.ssoadmin.model.PermissionsBoundary.ReadOnly =
      zio.aws.ssoadmin.model.PermissionsBoundary
        .wrap(impl.permissionsBoundary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest
  ): zio.aws.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
