package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{PermissionSetArn, InstanceArn}
import scala.jdk.CollectionConverters._
final case class GetInlinePolicyForPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest = {
    import GetInlinePolicyForPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetRequest
      .wrap(buildAwsValue())
}
object GetInlinePolicyForPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetRequest =
      zio.aws.ssoadmin.model
        .GetInlinePolicyForPermissionSetRequest(instanceArn, permissionSetArn)
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest
  ): zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
