package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.PermissionSetPolicyDocument
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetInlinePolicyForPermissionSetResponse(
    inlinePolicy: Optional[PermissionSetPolicyDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse = {
    import GetInlinePolicyForPermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse
      .builder()
      .optionallyWith(
        inlinePolicy.map(value =>
          PermissionSetPolicyDocument.unwrap(value): java.lang.String
        )
      )(_.inlinePolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse
      .wrap(buildAwsValue())
}
object GetInlinePolicyForPermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse =
      zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse(
        inlinePolicy.map(value => value)
      )
    def inlinePolicy: Optional[PermissionSetPolicyDocument]
    def getInlinePolicy: ZIO[Any, AwsError, PermissionSetPolicyDocument] =
      AwsError.unwrapOptionField("inlinePolicy", inlinePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse
  ) extends zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse.ReadOnly {
    override val inlinePolicy: Optional[PermissionSetPolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inlinePolicy())
        .map(value =>
          zio.aws.ssoadmin.model.primitives.PermissionSetPolicyDocument(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse
  ): zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse.ReadOnly =
    new Wrapper(impl)
}
