package zio.aws.ssoadmin.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  Token,
  MaxResults,
  PermissionSetArn,
  InstanceArn
}
import scala.jdk.CollectionConverters._
final case class ListAccountsForProvisionedPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    provisioningStatus: Option[zio.aws.ssoadmin.model.ProvisioningStatus] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest = {
    import ListAccountsForProvisionedPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .optionallyWith(provisioningStatus.map(value => value.unwrap))(
        _.provisioningStatus
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
      .wrap(buildAwsValue())
}
object ListAccountsForProvisionedPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest =
      zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest(
        instanceArn,
        permissionSetArn,
        provisioningStatus.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def provisioningStatus: Option[zio.aws.ssoadmin.model.ProvisioningStatus]
    def maxResults: Option[MaxResults]
    def nextToken: Option[Token]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getProvisioningStatus
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.ProvisioningStatus] =
      AwsError.unwrapOptionField("provisioningStatus", provisioningStatus)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val provisioningStatus
        : Option[zio.aws.ssoadmin.model.ProvisioningStatus] = scala
      .Option(impl.provisioningStatus())
      .map(value => zio.aws.ssoadmin.model.ProvisioningStatus.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssoadmin.model.primitives.MaxResults(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
  ): zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
