package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListInstancesResponse(
    instances: Option[Iterable[zio.aws.ssoadmin.model.InstanceMetadata]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse = {
    import ListInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.ListInstancesResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListInstancesResponse.wrap(buildAwsValue())
}
object ListInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ListInstancesResponse =
      zio.aws.ssoadmin.model.ListInstancesResponse(
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instances
        : Option[List[zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly]]
    def nextToken: Option[Token]
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse
  ) extends zio.aws.ssoadmin.model.ListInstancesResponse.ReadOnly {
    override val instances
        : Option[List[zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly]] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.InstanceMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse
  ): zio.aws.ssoadmin.model.ListInstancesResponse.ReadOnly = new Wrapper(impl)
}
