package zio.aws.ssoadmin.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{Token, MaxResults, InstanceArn}
import scala.jdk.CollectionConverters._
final case class ListAccountAssignmentCreationStatusRequest(
    instanceArn: InstanceArn,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[Token] = None,
    filter: Option[zio.aws.ssoadmin.model.OperationStatusFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest = {
    import ListAccountAssignmentCreationStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusRequest
      .wrap(buildAwsValue())
}
object ListAccountAssignmentCreationStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusRequest =
      zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusRequest(
        instanceArn,
        maxResults.map(value => value),
        nextToken.map(value => value),
        filter.map(value => value.asEditable)
      )
    def instanceArn: InstanceArn
    def maxResults: Option[MaxResults]
    def nextToken: Option[Token]
    def filter: Option[zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest
  ) extends zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssoadmin.model.primitives.MaxResults(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
    override val filter
        : Option[zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => zio.aws.ssoadmin.model.OperationStatusFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest
  ): zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusRequest.ReadOnly =
    new Wrapper(impl)
}
