package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{InstanceArn, UUId}
import scala.jdk.CollectionConverters._
final case class DescribeAccountAssignmentCreationStatusRequest(
    accountAssignmentCreationRequestId: UUId,
    instanceArn: InstanceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest = {
    import DescribeAccountAssignmentCreationStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
      .builder()
      .accountAssignmentCreationRequestId(
        UUId.unwrap(accountAssignmentCreationRequestId): java.lang.String
      )
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest.ReadOnly =
    zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
      .wrap(buildAwsValue())
}
object DescribeAccountAssignmentCreationStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest =
      zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest(
        accountAssignmentCreationRequestId,
        instanceArn
      )
    def accountAssignmentCreationRequestId: UUId
    def instanceArn: InstanceArn
    def getAccountAssignmentCreationRequestId: ZIO[Any, Nothing, UUId] =
      ZIO.succeed(accountAssignmentCreationRequestId)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
  ) extends zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest.ReadOnly {
    override val accountAssignmentCreationRequestId: UUId =
      zio.aws.ssoadmin.model.primitives
        .UUId(impl.accountAssignmentCreationRequestId())
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
  ): zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest.ReadOnly =
    new Wrapper(impl)
}
