package zio.aws.ssoadmin.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{
  Date,
  AccountId,
  UUId,
  PermissionSetArn,
  Reason
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PermissionSetProvisioningStatus(
    accountId: Optional[AccountId] = Optional.Absent,
    createdDate: Optional[Date] = Optional.Absent,
    failureReason: Optional[Reason] = Optional.Absent,
    permissionSetArn: Optional[PermissionSetArn] = Optional.Absent,
    requestId: Optional[UUId] = Optional.Absent,
    status: Optional[zio.aws.ssoadmin.model.StatusValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus = {
    import PermissionSetProvisioningStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(createdDate.map(value => Date.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(
        failureReason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.failureReason)
      .optionallyWith(
        permissionSetArn.map(value =>
          PermissionSetArn.unwrap(value): java.lang.String
        )
      )(_.permissionSetArn)
      .optionallyWith(
        requestId.map(value => UUId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.ReadOnly =
    zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.wrap(buildAwsValue())
}
object PermissionSetProvisioningStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.PermissionSetProvisioningStatus =
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatus(
        accountId.map(value => value),
        createdDate.map(value => value),
        failureReason.map(value => value),
        permissionSetArn.map(value => value),
        requestId.map(value => value),
        status.map(value => value)
      )
    def accountId: Optional[AccountId]
    def createdDate: Optional[Date]
    def failureReason: Optional[Reason]
    def permissionSetArn: Optional[PermissionSetArn]
    def requestId: Optional[UUId]
    def status: Optional[zio.aws.ssoadmin.model.StatusValues]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCreatedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getFailureReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getPermissionSetArn: ZIO[Any, AwsError, PermissionSetArn] =
      AwsError.unwrapOptionField("permissionSetArn", permissionSetArn)
    def getRequestId: ZIO[Any, AwsError, UUId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssoadmin.model.StatusValues] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus
  ) extends zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.ssoadmin.model.primitives.AccountId(value))
    override val createdDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssoadmin.model.primitives.Date(value))
    override val failureReason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.ssoadmin.model.primitives.Reason(value))
    override val permissionSetArn: Optional[PermissionSetArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionSetArn())
        .map(value => zio.aws.ssoadmin.model.primitives.PermissionSetArn(value))
    override val requestId: Optional[UUId] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.ssoadmin.model.primitives.UUId(value))
    override val status: Optional[zio.aws.ssoadmin.model.StatusValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssoadmin.model.StatusValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus
  ): zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.ReadOnly =
    new Wrapper(impl)
}
