package zio.aws.ssoadmin.model
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{
  Token,
  MaxResults,
  InstanceArn,
  AccountId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPermissionSetsProvisionedToAccountRequest(
    accountId: AccountId,
    instanceArn: InstanceArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    provisioningStatus: Optional[zio.aws.ssoadmin.model.ProvisioningStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest = {
    import ListPermissionSetsProvisionedToAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(provisioningStatus.map(value => value.unwrap))(
        _.provisioningStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
      .wrap(buildAwsValue())
}
object ListPermissionSetsProvisionedToAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest =
      zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest(
        accountId,
        instanceArn,
        maxResults.map(value => value),
        nextToken.map(value => value),
        provisioningStatus.map(value => value)
      )
    def accountId: AccountId
    def instanceArn: InstanceArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[Token]
    def provisioningStatus: Optional[zio.aws.ssoadmin.model.ProvisioningStatus]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProvisioningStatus
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.ProvisioningStatus] =
      AwsError.unwrapOptionField("provisioningStatus", provisioningStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
  ) extends zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.ssoadmin.model.primitives.AccountId(impl.accountId())
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssoadmin.model.primitives.MaxResults(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
    override val provisioningStatus
        : Optional[zio.aws.ssoadmin.model.ProvisioningStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningStatus())
        .map(value => zio.aws.ssoadmin.model.ProvisioningStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
  ): zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest.ReadOnly =
    new Wrapper(impl)
}
