package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccountAssignmentDeletionStatusResponse(
    accountAssignmentsDeletionStatus: Optional[
      Iterable[zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse = {
    import ListAccountAssignmentDeletionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse
      .builder()
      .optionallyWith(
        accountAssignmentsDeletionStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountAssignmentsDeletionStatus)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse
      .wrap(buildAwsValue())
}
object ListAccountAssignmentDeletionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse =
      zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse(
        accountAssignmentsDeletionStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accountAssignmentsDeletionStatus: Optional[List[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
    ]]
    def nextToken: Optional[Token]
    def getAccountAssignmentsDeletionStatus: ZIO[Any, AwsError, List[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountAssignmentsDeletionStatus",
      accountAssignmentsDeletionStatus
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse
  ) extends zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse.ReadOnly {
    override val accountAssignmentsDeletionStatus: Optional[List[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAssignmentsDeletionStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse
  ): zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
