package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{InstanceArn, Id}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceMetadata(
    identityStoreId: Optional[Id] = Optional.Absent,
    instanceArn: Optional[InstanceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.InstanceMetadata = {
    import InstanceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.InstanceMetadata
      .builder()
      .optionallyWith(
        identityStoreId.map(value => Id.unwrap(value): java.lang.String)
      )(_.identityStoreId)
      .optionallyWith(
        instanceArn.map(value => InstanceArn.unwrap(value): java.lang.String)
      )(_.instanceArn)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly =
    zio.aws.ssoadmin.model.InstanceMetadata.wrap(buildAwsValue())
}
object InstanceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.InstanceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.InstanceMetadata =
      zio.aws.ssoadmin.model.InstanceMetadata(
        identityStoreId.map(value => value),
        instanceArn.map(value => value)
      )
    def identityStoreId: Optional[Id]
    def instanceArn: Optional[InstanceArn]
    def getIdentityStoreId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("identityStoreId", identityStoreId)
    def getInstanceArn: ZIO[Any, AwsError, InstanceArn] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.InstanceMetadata
  ) extends zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly {
    override val identityStoreId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.identityStoreId())
      .map(value => zio.aws.ssoadmin.model.primitives.Id(value))
    override val instanceArn: Optional[InstanceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceArn())
      .map(value => zio.aws.ssoadmin.model.primitives.InstanceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.InstanceMetadata
  ): zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly = new Wrapper(impl)
}
