package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{Token, PermissionSetArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPermissionSetsResponse(
    permissionSets: Optional[Iterable[PermissionSetArn]] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse = {
    import ListPermissionSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse
      .builder()
      .optionallyWith(
        permissionSets.map(value =>
          value.map { item =>
            PermissionSetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissionSets)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.ListPermissionSetsResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListPermissionSetsResponse.wrap(buildAwsValue())
}
object ListPermissionSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ListPermissionSetsResponse =
      zio.aws.ssoadmin.model.ListPermissionSetsResponse(
        permissionSets.map(value => value),
        nextToken.map(value => value)
      )
    def permissionSets: Optional[List[PermissionSetArn]]
    def nextToken: Optional[Token]
    def getPermissionSets: ZIO[Any, AwsError, List[PermissionSetArn]] =
      AwsError.unwrapOptionField("permissionSets", permissionSets)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse
  ) extends zio.aws.ssoadmin.model.ListPermissionSetsResponse.ReadOnly {
    override val permissionSets: Optional[List[PermissionSetArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssoadmin.model.primitives.PermissionSetArn(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse
  ): zio.aws.ssoadmin.model.ListPermissionSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
