package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPermissionsBoundaryForPermissionSetResponse(
    permissionsBoundary: Optional[zio.aws.ssoadmin.model.PermissionsBoundary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse = {
    import GetPermissionsBoundaryForPermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse
      .builder()
      .optionallyWith(permissionsBoundary.map(value => value.buildAwsValue()))(
        _.permissionsBoundary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse
      .wrap(buildAwsValue())
}
object GetPermissionsBoundaryForPermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse =
      zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse(
        permissionsBoundary.map(value => value.asEditable)
      )
    def permissionsBoundary
        : Optional[zio.aws.ssoadmin.model.PermissionsBoundary.ReadOnly]
    def getPermissionsBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.PermissionsBoundary.ReadOnly
    ] = AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse
  ) extends zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse.ReadOnly {
    override val permissionsBoundary
        : Optional[zio.aws.ssoadmin.model.PermissionsBoundary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionsBoundary())
        .map(value => zio.aws.ssoadmin.model.PermissionsBoundary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse
  ): zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse.ReadOnly =
    new Wrapper(impl)
}
