package zio.aws.ssoadmin.model
import scala.jdk.CollectionConverters._
sealed trait TargetType {
  def unwrap: software.amazon.awssdk.services.ssoadmin.model.TargetType
}
object TargetType {
  def wrap(
      value: software.amazon.awssdk.services.ssoadmin.model.TargetType
  ): zio.aws.ssoadmin.model.TargetType = value match {
    case software.amazon.awssdk.services.ssoadmin.model.TargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssoadmin.model.TargetType.AWS_ACCOUNT =>
      val r = AWS_ACCOUNT
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssoadmin.model.TargetType {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.TargetType =
      software.amazon.awssdk.services.ssoadmin.model.TargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_ACCOUNT extends zio.aws.ssoadmin.model.TargetType {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.TargetType =
      software.amazon.awssdk.services.ssoadmin.model.TargetType.AWS_ACCOUNT
  }
}
