package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    nextToken: Optional[Token] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ssoadmin.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ListTagsForResourceResponse =
      zio.aws.ssoadmin.model.ListTagsForResourceResponse(
        nextToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[Token]
    def tags: Optional[List[zio.aws.ssoadmin.model.Tag.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssoadmin.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse
  ) extends zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
    override val tags: Optional[List[zio.aws.ssoadmin.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssoadmin.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse
  ): zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
