package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAccountAssignmentResponse(
    accountAssignmentCreationStatus: Optional[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse = {
    import CreateAccountAssignmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse
      .builder()
      .optionallyWith(
        accountAssignmentCreationStatus.map(value => value.buildAwsValue())
      )(_.accountAssignmentCreationStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.ReadOnly =
    zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.wrap(buildAwsValue())
}
object CreateAccountAssignmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.CreateAccountAssignmentResponse =
      zio.aws.ssoadmin.model.CreateAccountAssignmentResponse(
        accountAssignmentCreationStatus.map(value => value.asEditable)
      )
    def accountAssignmentCreationStatus: Optional[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly
    ]
    def getAccountAssignmentCreationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountAssignmentCreationStatus",
      accountAssignmentCreationStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse
  ) extends zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.ReadOnly {
    override val accountAssignmentCreationStatus: Optional[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAssignmentCreationStatus())
      .map(value =>
        zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse
  ): zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.ReadOnly =
    new Wrapper(impl)
}
