package zio.aws.ssoadmin.model
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{Token, MaxResults, InstanceArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPermissionSetProvisioningStatusRequest(
    filter: Optional[zio.aws.ssoadmin.model.OperationStatusFilter] =
      Optional.Absent,
    instanceArn: InstanceArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest = {
    import ListPermissionSetProvisioningStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusRequest
      .wrap(buildAwsValue())
}
object ListPermissionSetProvisioningStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusRequest =
      zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusRequest(
        filter.map(value => value.asEditable),
        instanceArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Optional[zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly]
    def instanceArn: InstanceArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[Token]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest
  ) extends zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.ssoadmin.model.OperationStatusFilter.wrap(value))
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssoadmin.model.primitives.MaxResults(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest
  ): zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusRequest.ReadOnly =
    new Wrapper(impl)
}
