package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{
  ManagedPolicyArn,
  PermissionSetArn,
  InstanceArn
}
import scala.jdk.CollectionConverters._
final case class DetachManagedPolicyFromPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    managedPolicyArn: ManagedPolicyArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest = {
    import DetachManagedPolicyFromPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .managedPolicyArn(
        ManagedPolicyArn.unwrap(managedPolicyArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest
      .wrap(buildAwsValue())
}
object DetachManagedPolicyFromPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest =
      zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest(
        instanceArn,
        permissionSetArn,
        managedPolicyArn
      )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def managedPolicyArn: ManagedPolicyArn
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getManagedPolicyArn: ZIO[Any, Nothing, ManagedPolicyArn] =
      ZIO.succeed(managedPolicyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val managedPolicyArn: ManagedPolicyArn =
      zio.aws.ssoadmin.model.primitives
        .ManagedPolicyArn(impl.managedPolicyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest
  ): zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
