package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{PermissionSetArn, Token}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPermissionSetsProvisionedToAccountResponse(
    nextToken: Optional[Token] = Optional.Absent,
    permissionSets: Optional[Iterable[PermissionSetArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse = {
    import ListPermissionSetsProvisionedToAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        permissionSets.map(value =>
          value.map { item =>
            PermissionSetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.permissionSets)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse
      .wrap(buildAwsValue())
}
object ListPermissionSetsProvisionedToAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse =
      zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse(
        nextToken.map(value => value),
        permissionSets.map(value => value)
      )
    def nextToken: Optional[Token]
    def permissionSets: Optional[List[PermissionSetArn]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPermissionSets: ZIO[Any, AwsError, List[PermissionSetArn]] =
      AwsError.unwrapOptionField("permissionSets", permissionSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse
  ) extends zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
    override val permissionSets: Optional[List[PermissionSetArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssoadmin.model.primitives.PermissionSetArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse
  ): zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse.ReadOnly =
    new Wrapper(impl)
}
