package zio.aws.ssoadmin.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{
  Date,
  AccountId,
  UUId,
  PermissionSetArn,
  Reason
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PermissionSetProvisioningStatus(
    status: Optional[zio.aws.ssoadmin.model.StatusValues] = Optional.Absent,
    requestId: Optional[UUId] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    permissionSetArn: Optional[PermissionSetArn] = Optional.Absent,
    failureReason: Optional[Reason] = Optional.Absent,
    createdDate: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus = {
    import PermissionSetProvisioningStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        requestId.map(value => UUId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        permissionSetArn.map(value =>
          PermissionSetArn.unwrap(value): java.lang.String
        )
      )(_.permissionSetArn)
      .optionallyWith(
        failureReason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.failureReason)
      .optionallyWith(createdDate.map(value => Date.unwrap(value): Instant))(
        _.createdDate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.ReadOnly =
    zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.wrap(buildAwsValue())
}
object PermissionSetProvisioningStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.PermissionSetProvisioningStatus =
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatus(
        status.map(value => value),
        requestId.map(value => value),
        accountId.map(value => value),
        permissionSetArn.map(value => value),
        failureReason.map(value => value),
        createdDate.map(value => value)
      )
    def status: Optional[zio.aws.ssoadmin.model.StatusValues]
    def requestId: Optional[UUId]
    def accountId: Optional[AccountId]
    def permissionSetArn: Optional[PermissionSetArn]
    def failureReason: Optional[Reason]
    def createdDate: Optional[Date]
    def getStatus: ZIO[Any, AwsError, zio.aws.ssoadmin.model.StatusValues] =
      AwsError.unwrapOptionField("status", status)
    def getRequestId: ZIO[Any, AwsError, UUId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getPermissionSetArn: ZIO[Any, AwsError, PermissionSetArn] =
      AwsError.unwrapOptionField("permissionSetArn", permissionSetArn)
    def getFailureReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getCreatedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdDate", createdDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus
  ) extends zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.ReadOnly {
    override val status: Optional[zio.aws.ssoadmin.model.StatusValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssoadmin.model.StatusValues.wrap(value))
    override val requestId: Optional[UUId] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.ssoadmin.model.primitives.UUId(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.ssoadmin.model.primitives.AccountId(value))
    override val permissionSetArn: Optional[PermissionSetArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionSetArn())
        .map(value => zio.aws.ssoadmin.model.primitives.PermissionSetArn(value))
    override val failureReason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.ssoadmin.model.primitives.Reason(value))
    override val createdDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssoadmin.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatus
  ): zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.ReadOnly =
    new Wrapper(impl)
}
