package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAccountAssignmentCreationStatusResponse(
    accountAssignmentCreationStatus: Optional[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse = {
    import DescribeAccountAssignmentCreationStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse
      .builder()
      .optionallyWith(
        accountAssignmentCreationStatus.map(value => value.buildAwsValue())
      )(_.accountAssignmentCreationStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse.ReadOnly =
    zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse
      .wrap(buildAwsValue())
}
object DescribeAccountAssignmentCreationStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse =
      zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse(
        accountAssignmentCreationStatus.map(value => value.asEditable)
      )
    def accountAssignmentCreationStatus: Optional[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly
    ]
    def getAccountAssignmentCreationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountAssignmentCreationStatus",
      accountAssignmentCreationStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse
  ) extends zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse.ReadOnly {
    override val accountAssignmentCreationStatus: Optional[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAssignmentCreationStatus())
      .map(value =>
        zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse
  ): zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse.ReadOnly =
    new Wrapper(impl)
}
