package zio.aws.ssoadmin.model
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{
  Token,
  MaxResults,
  PermissionSetArn,
  InstanceArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListManagedPoliciesInPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest = {
    import ListManagedPoliciesInPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest
      .wrap(buildAwsValue())
}
object ListManagedPoliciesInPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest =
      zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest(
        instanceArn,
        permissionSetArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[Token]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssoadmin.model.primitives.MaxResults(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest
  ): zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
