package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{TagKey, GeneralArn, InstanceArn}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    instanceArn: InstanceArn,
    resourceArn: GeneralArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .resourceArn(GeneralArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.UntagResourceRequest.ReadOnly =
    zio.aws.ssoadmin.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.UntagResourceRequest =
      zio.aws.ssoadmin.model
        .UntagResourceRequest(instanceArn, resourceArn, tagKeys)
    def instanceArn: InstanceArn
    def resourceArn: GeneralArn
    def tagKeys: List[TagKey]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getResourceArn: ZIO[Any, Nothing, GeneralArn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest
  ) extends zio.aws.ssoadmin.model.UntagResourceRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val resourceArn: GeneralArn =
      zio.aws.ssoadmin.model.primitives.GeneralArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.ssoadmin.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest
  ): zio.aws.ssoadmin.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
