package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{ManagedPolicyArn, Name}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachedManagedPolicy(
    name: Optional[Name] = Optional.Absent,
    arn: Optional[ManagedPolicyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy = {
    import AttachedManagedPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        arn.map(value => ManagedPolicyArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly =
    zio.aws.ssoadmin.model.AttachedManagedPolicy.wrap(buildAwsValue())
}
object AttachedManagedPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.AttachedManagedPolicy =
      zio.aws.ssoadmin.model.AttachedManagedPolicy(
        name.map(value => value),
        arn.map(value => value)
      )
    def name: Optional[Name]
    def arn: Optional[ManagedPolicyArn]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, ManagedPolicyArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy
  ) extends zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssoadmin.model.primitives.Name(value))
    override val arn: Optional[ManagedPolicyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ssoadmin.model.primitives.ManagedPolicyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.AttachedManagedPolicy
  ): zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly = new Wrapper(impl)
}
