package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.InstanceArn
import scala.jdk.CollectionConverters._
final case class CreateInstanceAccessControlAttributeConfigurationRequest(
    instanceArn: InstanceArn,
    instanceAccessControlAttributeConfiguration: zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest = {
    import CreateInstanceAccessControlAttributeConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .instanceAccessControlAttributeConfiguration(
        instanceAccessControlAttributeConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest.ReadOnly =
    zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateInstanceAccessControlAttributeConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest =
      zio.aws.ssoadmin.model
        .CreateInstanceAccessControlAttributeConfigurationRequest(
          instanceArn,
          instanceAccessControlAttributeConfiguration.asEditable
        )
    def instanceArn: InstanceArn
    def instanceAccessControlAttributeConfiguration
        : zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getInstanceAccessControlAttributeConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    ] = ZIO.succeed(instanceAccessControlAttributeConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
  ) extends zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val instanceAccessControlAttributeConfiguration
        : zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly =
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
        .wrap(impl.instanceAccessControlAttributeConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
  ): zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
