package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{Token, GeneralArn, InstanceArn}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    instanceArn: InstanceArn,
    resourceArn: GeneralArn,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .resourceArn(GeneralArn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ListTagsForResourceRequest =
      zio.aws.ssoadmin.model.ListTagsForResourceRequest(
        instanceArn,
        resourceArn,
        nextToken.map(value => value)
      )
    def instanceArn: InstanceArn
    def resourceArn: GeneralArn
    def nextToken: Option[Token]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getResourceArn: ZIO[Any, Nothing, GeneralArn] = ZIO.succeed(resourceArn)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest
  ) extends zio.aws.ssoadmin.model.ListTagsForResourceRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val resourceArn: GeneralArn =
      zio.aws.ssoadmin.model.primitives.GeneralArn(impl.resourceArn())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest
  ): zio.aws.ssoadmin.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
