package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OperationStatusFilter(
    status: Option[zio.aws.ssoadmin.model.StatusValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter = {
    import OperationStatusFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly =
    zio.aws.ssoadmin.model.OperationStatusFilter.wrap(buildAwsValue())
}
object OperationStatusFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.OperationStatusFilter =
      zio.aws.ssoadmin.model.OperationStatusFilter(status.map(value => value))
    def status: Option[zio.aws.ssoadmin.model.StatusValues]
    def getStatus: ZIO[Any, AwsError, zio.aws.ssoadmin.model.StatusValues] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter
  ) extends zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly {
    override val status: Option[zio.aws.ssoadmin.model.StatusValues] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssoadmin.model.StatusValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter
  ): zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly = new Wrapper(impl)
}
