package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  Date,
  UUId,
  PermissionSetArn,
  TargetId,
  PrincipalId,
  Reason
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AccountAssignmentOperationStatus(
    status: Option[zio.aws.ssoadmin.model.StatusValues] = None,
    requestId: Option[UUId] = None,
    failureReason: Option[Reason] = None,
    targetId: Option[TargetId] = None,
    targetType: Option[zio.aws.ssoadmin.model.TargetType] = None,
    permissionSetArn: Option[PermissionSetArn] = None,
    principalType: Option[zio.aws.ssoadmin.model.PrincipalType] = None,
    principalId: Option[PrincipalId] = None,
    createdDate: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus = {
    import AccountAssignmentOperationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        requestId.map(value => UUId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        failureReason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.failureReason)
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(
        permissionSetArn.map(value =>
          PermissionSetArn.unwrap(value): java.lang.String
        )
      )(_.permissionSetArn)
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .optionallyWith(
        principalId.map(value => PrincipalId.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(createdDate.map(value => Date.unwrap(value): Instant))(
        _.createdDate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly =
    zio.aws.ssoadmin.model.AccountAssignmentOperationStatus
      .wrap(buildAwsValue())
}
object AccountAssignmentOperationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.AccountAssignmentOperationStatus =
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus(
        status.map(value => value),
        requestId.map(value => value),
        failureReason.map(value => value),
        targetId.map(value => value),
        targetType.map(value => value),
        permissionSetArn.map(value => value),
        principalType.map(value => value),
        principalId.map(value => value),
        createdDate.map(value => value)
      )
    def status: Option[zio.aws.ssoadmin.model.StatusValues]
    def requestId: Option[UUId]
    def failureReason: Option[Reason]
    def targetId: Option[TargetId]
    def targetType: Option[zio.aws.ssoadmin.model.TargetType]
    def permissionSetArn: Option[PermissionSetArn]
    def principalType: Option[zio.aws.ssoadmin.model.PrincipalType]
    def principalId: Option[PrincipalId]
    def createdDate: Option[Date]
    def getStatus: ZIO[Any, AwsError, zio.aws.ssoadmin.model.StatusValues] =
      AwsError.unwrapOptionField("status", status)
    def getRequestId: ZIO[Any, AwsError, UUId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getFailureReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getTargetType: ZIO[Any, AwsError, zio.aws.ssoadmin.model.TargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getPermissionSetArn: ZIO[Any, AwsError, PermissionSetArn] =
      AwsError.unwrapOptionField("permissionSetArn", permissionSetArn)
    def getPrincipalType
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
    def getPrincipalId: ZIO[Any, AwsError, PrincipalId] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getCreatedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdDate", createdDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus
  ) extends zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly {
    override val status: Option[zio.aws.ssoadmin.model.StatusValues] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssoadmin.model.StatusValues.wrap(value))
    override val requestId: Option[UUId] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.ssoadmin.model.primitives.UUId(value))
    override val failureReason: Option[Reason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.ssoadmin.model.primitives.Reason(value))
    override val targetId: Option[TargetId] = scala
      .Option(impl.targetId())
      .map(value => zio.aws.ssoadmin.model.primitives.TargetId(value))
    override val targetType: Option[zio.aws.ssoadmin.model.TargetType] = scala
      .Option(impl.targetType())
      .map(value => zio.aws.ssoadmin.model.TargetType.wrap(value))
    override val permissionSetArn: Option[PermissionSetArn] = scala
      .Option(impl.permissionSetArn())
      .map(value => zio.aws.ssoadmin.model.primitives.PermissionSetArn(value))
    override val principalType: Option[zio.aws.ssoadmin.model.PrincipalType] =
      scala
        .Option(impl.principalType())
        .map(value => zio.aws.ssoadmin.model.PrincipalType.wrap(value))
    override val principalId: Option[PrincipalId] = scala
      .Option(impl.principalId())
      .map(value => zio.aws.ssoadmin.model.primitives.PrincipalId(value))
    override val createdDate: Option[Date] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ssoadmin.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatus
  ): zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly =
    new Wrapper(impl)
}
