package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListManagedPoliciesInPermissionSetResponse(
    attachedManagedPolicies: Option[
      Iterable[zio.aws.ssoadmin.model.AttachedManagedPolicy]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse = {
    import ListManagedPoliciesInPermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
      .builder()
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
      .wrap(buildAwsValue())
}
object ListManagedPoliciesInPermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse =
      zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attachedManagedPolicies
        : Option[List[zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly]]
    def nextToken: Option[Token]
    def getAttachedManagedPolicies: ZIO[Any, AwsError, List[
      zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachedManagedPolicies",
      attachedManagedPolicies
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
  ) extends zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly {
    override val attachedManagedPolicies
        : Option[List[zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly]] =
      scala
        .Option(impl.attachedManagedPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssoadmin.model.AttachedManagedPolicy.wrap(item)
          }.toList
        )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
  ): zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly =
    new Wrapper(impl)
}
