package zio.aws.ssoadmin
import zio.aws.ssoadmin.model.ProvisionPermissionSetResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.ssoadmin.model.primitives.{AccountId, PermissionSetArn}
import software.amazon.awssdk.services.ssoadmin.{
  SsoAdminAsyncClientBuilder,
  SsoAdminAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.aws.ssoadmin.model.{
  ListPermissionSetsRequest,
  CreateAccountAssignmentRequest,
  DeleteInlinePolicyFromPermissionSetRequest,
  CreateInstanceAccessControlAttributeConfigurationRequest,
  ListPermissionSetsProvisionedToAccountRequest,
  ListInstancesRequest,
  AttachManagedPolicyToPermissionSetRequest,
  ListTagsForResourceRequest,
  DetachManagedPolicyFromPermissionSetRequest,
  ListAccountAssignmentsRequest,
  DescribeInstanceAccessControlAttributeConfigurationRequest,
  DescribeAccountAssignmentDeletionStatusRequest,
  DeleteInstanceAccessControlAttributeConfigurationRequest,
  DescribePermissionSetRequest,
  GetInlinePolicyForPermissionSetRequest,
  ProvisionPermissionSetRequest,
  ListManagedPoliciesInPermissionSetRequest,
  UpdateInstanceAccessControlAttributeConfigurationRequest,
  CreatePermissionSetRequest,
  UntagResourceRequest,
  DeletePermissionSetRequest,
  ListPermissionSetProvisioningStatusRequest,
  DescribePermissionSetProvisioningStatusRequest,
  PutInlinePolicyToPermissionSetRequest,
  DeleteAccountAssignmentRequest,
  DescribeAccountAssignmentCreationStatusRequest,
  ListAccountAssignmentDeletionStatusRequest,
  UpdatePermissionSetRequest,
  ListAccountsForProvisionedPermissionSetRequest,
  TagResourceRequest,
  ListAccountAssignmentCreationStatusRequest
}
import software.amazon.awssdk.services.ssoadmin.model.{
  ListInstancesResponse,
  CreateInstanceAccessControlAttributeConfigurationResponse,
  AttachedManagedPolicy,
  ListManagedPoliciesInPermissionSetResponse,
  DescribePermissionSetResponse,
  PermissionSetProvisioningStatusMetadata,
  AttachManagedPolicyToPermissionSetResponse,
  UpdatePermissionSetResponse,
  DescribePermissionSetProvisioningStatusResponse,
  DeleteInlinePolicyFromPermissionSetResponse,
  DetachManagedPolicyFromPermissionSetResponse,
  ListAccountAssignmentDeletionStatusResponse,
  Tag,
  DescribeInstanceAccessControlAttributeConfigurationResponse,
  DeletePermissionSetResponse,
  InstanceMetadata,
  AccountAssignment,
  ProvisionPermissionSetResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListPermissionSetsResponse,
  ListPermissionSetsProvisionedToAccountResponse,
  CreatePermissionSetResponse,
  PutInlinePolicyToPermissionSetResponse,
  DescribeAccountAssignmentCreationStatusResponse,
  ListPermissionSetProvisioningStatusResponse,
  DeleteInstanceAccessControlAttributeConfigurationResponse,
  GetInlinePolicyForPermissionSetResponse,
  ListAccountAssignmentCreationStatusResponse,
  ListAccountAssignmentsResponse,
  DeleteAccountAssignmentResponse,
  UpdateInstanceAccessControlAttributeConfigurationResponse,
  TagResourceResponse,
  CreateAccountAssignmentResponse,
  AccountAssignmentOperationStatusMetadata,
  DescribeAccountAssignmentDeletionStatusResponse,
  ListAccountsForProvisionedPermissionSetResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait SsoAdmin extends AspectSupport[SsoAdmin] {
  val api: SsoAdminAsyncClient
  def describePermissionSetProvisioningStatus(
      request: DescribePermissionSetProvisioningStatusRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse.ReadOnly
  ]
  def listPermissionSets(
      request: ListPermissionSetsRequest
  ): ZStream[Any, AwsError, PermissionSetArn]
  def listPermissionSetsPaginated(
      request: ListPermissionSetsRequest
  ): IO[AwsError, zio.aws.ssoadmin.model.ListPermissionSetsResponse.ReadOnly]
  def listAccountAssignmentDeletionStatus(
      request: ListAccountAssignmentDeletionStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
  ]
  def listAccountAssignmentDeletionStatusPaginated(
      request: ListAccountAssignmentDeletionStatusRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse.ReadOnly
  ]
  def detachManagedPolicyFromPermissionSet(
      request: DetachManagedPolicyFromPermissionSetRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse.ReadOnly
  ]
  def describePermissionSet(
      request: DescribePermissionSetRequest
  ): IO[AwsError, zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly]
  def describeInstanceAccessControlAttributeConfiguration(
      request: DescribeInstanceAccessControlAttributeConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly
  ]
  def listManagedPoliciesInPermissionSet(
      request: ListManagedPoliciesInPermissionSetRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly
  ]
  def listManagedPoliciesInPermissionSetPaginated(
      request: ListManagedPoliciesInPermissionSetRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly
  ]
  def createPermissionSet(
      request: CreatePermissionSetRequest
  ): IO[AwsError, zio.aws.ssoadmin.model.CreatePermissionSetResponse.ReadOnly]
  def createAccountAssignment(request: CreateAccountAssignmentRequest): IO[
    AwsError,
    zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.ReadOnly
  ]
  def listInstances(
      request: ListInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly]
  def listInstancesPaginated(
      request: ListInstancesRequest
  ): IO[AwsError, zio.aws.ssoadmin.model.ListInstancesResponse.ReadOnly]
  def listAccountAssignmentCreationStatus(
      request: ListAccountAssignmentCreationStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
  ]
  def listAccountAssignmentCreationStatusPaginated(
      request: ListAccountAssignmentCreationStatusRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse.ReadOnly
  ]
  def updatePermissionSet(
      request: UpdatePermissionSetRequest
  ): IO[AwsError, zio.aws.ssoadmin.model.UpdatePermissionSetResponse.ReadOnly]
  def deleteInlinePolicyFromPermissionSet(
      request: DeleteInlinePolicyFromPermissionSetRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse.ReadOnly
  ]
  def getInlinePolicyForPermissionSet(
      request: GetInlinePolicyForPermissionSetRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse.ReadOnly
  ]
  def attachManagedPolicyToPermissionSet(
      request: AttachManagedPolicyToPermissionSetRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse.ReadOnly
  ]
  def describeAccountAssignmentDeletionStatus(
      request: DescribeAccountAssignmentDeletionStatusRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.ssoadmin.model.UntagResourceResponse.ReadOnly]
  def deleteInstanceAccessControlAttributeConfiguration(
      request: DeleteInstanceAccessControlAttributeConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse.ReadOnly
  ]
  def deletePermissionSet(
      request: DeletePermissionSetRequest
  ): IO[AwsError, zio.aws.ssoadmin.model.DeletePermissionSetResponse.ReadOnly]
  def describeAccountAssignmentCreationStatus(
      request: DescribeAccountAssignmentCreationStatusRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse.ReadOnly
  ]
  def listPermissionSetProvisioningStatus(
      request: ListPermissionSetProvisioningStatusRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
  ]
  def listPermissionSetProvisioningStatusPaginated(
      request: ListPermissionSetProvisioningStatusRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.ssoadmin.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.ssoadmin.model.TagResourceResponse.ReadOnly]
  def provisionPermissionSet(
      request: ProvisionPermissionSetRequest
  ): IO[AwsError, ReadOnly]
  def listAccountsForProvisionedPermissionSet(
      request: ListAccountsForProvisionedPermissionSetRequest
  ): ZStream[Any, AwsError, AccountId]
  def listAccountsForProvisionedPermissionSetPaginated(
      request: ListAccountsForProvisionedPermissionSetRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse.ReadOnly
  ]
  def createInstanceAccessControlAttributeConfiguration(
      request: CreateInstanceAccessControlAttributeConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
  ]
  def listPermissionSetsProvisionedToAccount(
      request: ListPermissionSetsProvisionedToAccountRequest
  ): ZStream[Any, AwsError, PermissionSetArn]
  def listPermissionSetsProvisionedToAccountPaginated(
      request: ListPermissionSetsProvisionedToAccountRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse.ReadOnly
  ]
  def putInlinePolicyToPermissionSet(
      request: PutInlinePolicyToPermissionSetRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetResponse.ReadOnly
  ]
  def listAccountAssignments(
      request: ListAccountAssignmentsRequest
  ): ZStream[Any, AwsError, zio.aws.ssoadmin.model.AccountAssignment.ReadOnly]
  def listAccountAssignmentsPaginated(
      request: ListAccountAssignmentsRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.ReadOnly
  ]
  def deleteAccountAssignment(request: DeleteAccountAssignmentRequest): IO[
    AwsError,
    zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.ReadOnly
  ]
  def updateInstanceAccessControlAttributeConfiguration(
      request: UpdateInstanceAccessControlAttributeConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
  ]
}
object SsoAdmin {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SsoAdmin] = customized(
    identity
  )
  def customized(
      customization: SsoAdminAsyncClientBuilder => SsoAdminAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SsoAdmin] = managed(
    customization
  ).toLayer
  def managed(
      customization: SsoAdminAsyncClientBuilder => SsoAdminAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, SsoAdmin] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = SsoAdminAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SsoAdminAsyncClient, SsoAdminAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[SsoAdminAsyncClient, SsoAdminAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new SsoAdminImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SsoAdminImpl[R](
      override val api: SsoAdminAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SsoAdmin
      with AwsServiceBase[R] {
    override val serviceName: String = "SsoAdmin"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SsoAdminImpl[R1] = new SsoAdminImpl(api, newAspect, r)
    def describePermissionSetProvisioningStatus(
        request: DescribePermissionSetProvisioningStatusRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest,
      DescribePermissionSetProvisioningStatusResponse
    ](
      "describePermissionSetProvisioningStatus",
      api.describePermissionSetProvisioningStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse.wrap
      )
      .provideEnvironment(r)
    def listPermissionSets(
        request: ListPermissionSetsRequest
    ): ZStream[Any, AwsError, PermissionSetArn] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest,
      ListPermissionSetsResponse,
      java.lang.String
    ](
      "listPermissionSets",
      api.listPermissionSets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.permissionSets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssoadmin.model.primitives.PermissionSetArn(item))
      .provideEnvironment(r)
    def listPermissionSetsPaginated(request: ListPermissionSetsRequest): IO[
      AwsError,
      zio.aws.ssoadmin.model.ListPermissionSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest,
      ListPermissionSetsResponse
    ]("listPermissionSets", api.listPermissionSets)(request.buildAwsValue())
      .map(zio.aws.ssoadmin.model.ListPermissionSetsResponse.wrap)
      .provideEnvironment(r)
    def listAccountAssignmentDeletionStatus(
        request: ListAccountAssignmentDeletionStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest,
      ListAccountAssignmentDeletionStatusResponse,
      AccountAssignmentOperationStatusMetadata
    ](
      "listAccountAssignmentDeletionStatus",
      api.listAccountAssignmentDeletionStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accountAssignmentsDeletionStatus().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata
          .wrap(item)
      )
      .provideEnvironment(r)
    def listAccountAssignmentDeletionStatusPaginated(
        request: ListAccountAssignmentDeletionStatusRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest,
      ListAccountAssignmentDeletionStatusResponse
    ](
      "listAccountAssignmentDeletionStatus",
      api.listAccountAssignmentDeletionStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse.wrap
      )
      .provideEnvironment(r)
    def detachManagedPolicyFromPermissionSet(
        request: DetachManagedPolicyFromPermissionSetRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest,
      DetachManagedPolicyFromPermissionSetResponse
    ](
      "detachManagedPolicyFromPermissionSet",
      api.detachManagedPolicyFromPermissionSet
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse.wrap
      )
      .provideEnvironment(r)
    def describePermissionSet(request: DescribePermissionSetRequest): IO[
      AwsError,
      zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest,
      DescribePermissionSetResponse
    ]("describePermissionSet", api.describePermissionSet)(
      request.buildAwsValue()
    ).map(zio.aws.ssoadmin.model.DescribePermissionSetResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceAccessControlAttributeConfiguration(
        request: DescribeInstanceAccessControlAttributeConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest,
      DescribeInstanceAccessControlAttributeConfigurationResponse
    ](
      "describeInstanceAccessControlAttributeConfiguration",
      api.describeInstanceAccessControlAttributeConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listManagedPoliciesInPermissionSet(
        request: ListManagedPoliciesInPermissionSetRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest,
      ListManagedPoliciesInPermissionSetResponse,
      AttachedManagedPolicy
    ](
      "listManagedPoliciesInPermissionSet",
      api.listManagedPoliciesInPermissionSet,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.attachedManagedPolicies().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssoadmin.model.AttachedManagedPolicy.wrap(item))
      .provideEnvironment(r)
    def listManagedPoliciesInPermissionSetPaginated(
        request: ListManagedPoliciesInPermissionSetRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest,
      ListManagedPoliciesInPermissionSetResponse
    ](
      "listManagedPoliciesInPermissionSet",
      api.listManagedPoliciesInPermissionSet
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.wrap
      )
      .provideEnvironment(r)
    def createPermissionSet(request: CreatePermissionSetRequest): IO[
      AwsError,
      zio.aws.ssoadmin.model.CreatePermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest,
      CreatePermissionSetResponse
    ]("createPermissionSet", api.createPermissionSet)(request.buildAwsValue())
      .map(zio.aws.ssoadmin.model.CreatePermissionSetResponse.wrap)
      .provideEnvironment(r)
    def createAccountAssignment(request: CreateAccountAssignmentRequest): IO[
      AwsError,
      zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest,
      CreateAccountAssignmentResponse
    ]("createAccountAssignment", api.createAccountAssignment)(
      request.buildAwsValue()
    ).map(zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.wrap)
      .provideEnvironment(r)
    def listInstances(request: ListInstancesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest,
      ListInstancesResponse,
      InstanceMetadata
    ](
      "listInstances",
      api.listInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instances().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssoadmin.model.InstanceMetadata.wrap(item))
      .provideEnvironment(r)
    def listInstancesPaginated(
        request: ListInstancesRequest
    ): IO[AwsError, zio.aws.ssoadmin.model.ListInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest,
        ListInstancesResponse
      ]("listInstances", api.listInstances)(request.buildAwsValue())
        .map(zio.aws.ssoadmin.model.ListInstancesResponse.wrap)
        .provideEnvironment(r)
    def listAccountAssignmentCreationStatus(
        request: ListAccountAssignmentCreationStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest,
      ListAccountAssignmentCreationStatusResponse,
      AccountAssignmentOperationStatusMetadata
    ](
      "listAccountAssignmentCreationStatus",
      api.listAccountAssignmentCreationStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accountAssignmentsCreationStatus().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata
          .wrap(item)
      )
      .provideEnvironment(r)
    def listAccountAssignmentCreationStatusPaginated(
        request: ListAccountAssignmentCreationStatusRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest,
      ListAccountAssignmentCreationStatusResponse
    ](
      "listAccountAssignmentCreationStatus",
      api.listAccountAssignmentCreationStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse.wrap
      )
      .provideEnvironment(r)
    def updatePermissionSet(request: UpdatePermissionSetRequest): IO[
      AwsError,
      zio.aws.ssoadmin.model.UpdatePermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest,
      UpdatePermissionSetResponse
    ]("updatePermissionSet", api.updatePermissionSet)(request.buildAwsValue())
      .map(zio.aws.ssoadmin.model.UpdatePermissionSetResponse.wrap)
      .provideEnvironment(r)
    def deleteInlinePolicyFromPermissionSet(
        request: DeleteInlinePolicyFromPermissionSetRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest,
      DeleteInlinePolicyFromPermissionSetResponse
    ](
      "deleteInlinePolicyFromPermissionSet",
      api.deleteInlinePolicyFromPermissionSet
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse.wrap
      )
      .provideEnvironment(r)
    def getInlinePolicyForPermissionSet(
        request: GetInlinePolicyForPermissionSetRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest,
      GetInlinePolicyForPermissionSetResponse
    ]("getInlinePolicyForPermissionSet", api.getInlinePolicyForPermissionSet)(
      request.buildAwsValue()
    ).map(zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse.wrap)
      .provideEnvironment(r)
    def attachManagedPolicyToPermissionSet(
        request: AttachManagedPolicyToPermissionSetRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest,
      AttachManagedPolicyToPermissionSetResponse
    ](
      "attachManagedPolicyToPermissionSet",
      api.attachManagedPolicyToPermissionSet
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse.wrap
      )
      .provideEnvironment(r)
    def describeAccountAssignmentDeletionStatus(
        request: DescribeAccountAssignmentDeletionStatusRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest,
      DescribeAccountAssignmentDeletionStatusResponse
    ](
      "describeAccountAssignmentDeletionStatus",
      api.describeAccountAssignmentDeletionStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse.wrap
      )
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.ssoadmin.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.ssoadmin.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteInstanceAccessControlAttributeConfiguration(
        request: DeleteInstanceAccessControlAttributeConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationRequest,
      DeleteInstanceAccessControlAttributeConfigurationResponse
    ](
      "deleteInstanceAccessControlAttributeConfiguration",
      api.deleteInstanceAccessControlAttributeConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deletePermissionSet(request: DeletePermissionSetRequest): IO[
      AwsError,
      zio.aws.ssoadmin.model.DeletePermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetRequest,
      DeletePermissionSetResponse
    ]("deletePermissionSet", api.deletePermissionSet)(request.buildAwsValue())
      .map(zio.aws.ssoadmin.model.DeletePermissionSetResponse.wrap)
      .provideEnvironment(r)
    def describeAccountAssignmentCreationStatus(
        request: DescribeAccountAssignmentCreationStatusRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest,
      DescribeAccountAssignmentCreationStatusResponse
    ](
      "describeAccountAssignmentCreationStatus",
      api.describeAccountAssignmentCreationStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse.wrap
      )
      .provideEnvironment(r)
    def listPermissionSetProvisioningStatus(
        request: ListPermissionSetProvisioningStatusRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest,
      ListPermissionSetProvisioningStatusResponse,
      PermissionSetProvisioningStatusMetadata
    ](
      "listPermissionSetProvisioningStatus",
      api.listPermissionSetProvisioningStatus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.permissionSetsProvisioningStatus().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata
          .wrap(item)
      )
      .provideEnvironment(r)
    def listPermissionSetProvisioningStatusPaginated(
        request: ListPermissionSetProvisioningStatusRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest,
      ListPermissionSetProvisioningStatusResponse
    ](
      "listPermissionSetProvisioningStatus",
      api.listPermissionSetProvisioningStatus
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.Tag.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse,
      Tag
    ](
      "listTagsForResource",
      api.listTagsForResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tags().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssoadmin.model.Tag.wrap(item))
      .provideEnvironment(r)
    def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.ssoadmin.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.ssoadmin.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.ssoadmin.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def provisionPermissionSet(
        request: ProvisionPermissionSetRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest,
      ProvisionPermissionSetResponse
    ]("provisionPermissionSet", api.provisionPermissionSet)(
      request.buildAwsValue()
    ).map(zio.aws.ssoadmin.model.ProvisionPermissionSetResponse.wrap)
      .provideEnvironment(r)
    def listAccountsForProvisionedPermissionSet(
        request: ListAccountsForProvisionedPermissionSetRequest
    ): ZStream[Any, AwsError, AccountId] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest,
      ListAccountsForProvisionedPermissionSetResponse,
      java.lang.String
    ](
      "listAccountsForProvisionedPermissionSet",
      api.listAccountsForProvisionedPermissionSet,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accountIds().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssoadmin.model.primitives.AccountId(item))
      .provideEnvironment(r)
    def listAccountsForProvisionedPermissionSetPaginated(
        request: ListAccountsForProvisionedPermissionSetRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest,
      ListAccountsForProvisionedPermissionSetResponse
    ](
      "listAccountsForProvisionedPermissionSet",
      api.listAccountsForProvisionedPermissionSet
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse.wrap
      )
      .provideEnvironment(r)
    def createInstanceAccessControlAttributeConfiguration(
        request: CreateInstanceAccessControlAttributeConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest,
      CreateInstanceAccessControlAttributeConfigurationResponse
    ](
      "createInstanceAccessControlAttributeConfiguration",
      api.createInstanceAccessControlAttributeConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listPermissionSetsProvisionedToAccount(
        request: ListPermissionSetsProvisionedToAccountRequest
    ): ZStream[Any, AwsError, PermissionSetArn] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest,
      ListPermissionSetsProvisionedToAccountResponse,
      java.lang.String
    ](
      "listPermissionSetsProvisionedToAccount",
      api.listPermissionSetsProvisionedToAccount,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.permissionSets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssoadmin.model.primitives.PermissionSetArn(item))
      .provideEnvironment(r)
    def listPermissionSetsProvisionedToAccountPaginated(
        request: ListPermissionSetsProvisionedToAccountRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest,
      ListPermissionSetsProvisionedToAccountResponse
    ](
      "listPermissionSetsProvisionedToAccount",
      api.listPermissionSetsProvisionedToAccount
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse.wrap
      )
      .provideEnvironment(r)
    def putInlinePolicyToPermissionSet(
        request: PutInlinePolicyToPermissionSetRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest,
      PutInlinePolicyToPermissionSetResponse
    ]("putInlinePolicyToPermissionSet", api.putInlinePolicyToPermissionSet)(
      request.buildAwsValue()
    ).map(zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetResponse.wrap)
      .provideEnvironment(r)
    def listAccountAssignments(request: ListAccountAssignmentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.AccountAssignment.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest,
      ListAccountAssignmentsResponse,
      AccountAssignment
    ](
      "listAccountAssignments",
      api.listAccountAssignments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accountAssignments().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ssoadmin.model.AccountAssignment.wrap(item))
      .provideEnvironment(r)
    def listAccountAssignmentsPaginated(
        request: ListAccountAssignmentsRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest,
      ListAccountAssignmentsResponse
    ]("listAccountAssignments", api.listAccountAssignments)(
      request.buildAwsValue()
    ).map(zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.wrap)
      .provideEnvironment(r)
    def deleteAccountAssignment(request: DeleteAccountAssignmentRequest): IO[
      AwsError,
      zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest,
      DeleteAccountAssignmentResponse
    ]("deleteAccountAssignment", api.deleteAccountAssignment)(
      request.buildAwsValue()
    ).map(zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.wrap)
      .provideEnvironment(r)
    def updateInstanceAccessControlAttributeConfiguration(
        request: UpdateInstanceAccessControlAttributeConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest,
      UpdateInstanceAccessControlAttributeConfigurationResponse
    ](
      "updateInstanceAccessControlAttributeConfiguration",
      api.updateInstanceAccessControlAttributeConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse.wrap
      )
      .provideEnvironment(r)
  }
  def describePermissionSetProvisioningStatus(
      request: DescribePermissionSetProvisioningStatusRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePermissionSetProvisioningStatus(request))
  def listPermissionSets(
      request: ListPermissionSetsRequest
  ): ZStream[zio.aws.ssoadmin.SsoAdmin, AwsError, PermissionSetArn] =
    ZStream.serviceWithStream(_.listPermissionSets(request))
  def listPermissionSetsPaginated(request: ListPermissionSetsRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListPermissionSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPermissionSetsPaginated(request))
  def listAccountAssignmentDeletionStatus(
      request: ListAccountAssignmentDeletionStatusRequest
  ): ZStream[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccountAssignmentDeletionStatus(request))
  def listAccountAssignmentDeletionStatusPaginated(
      request: ListAccountAssignmentDeletionStatusRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listAccountAssignmentDeletionStatusPaginated(request))
  def detachManagedPolicyFromPermissionSet(
      request: DetachManagedPolicyFromPermissionSetRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachManagedPolicyFromPermissionSet(request))
  def describePermissionSet(request: DescribePermissionSetRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePermissionSet(request))
  def describeInstanceAccessControlAttributeConfiguration(
      request: DescribeInstanceAccessControlAttributeConfigurationRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeInstanceAccessControlAttributeConfiguration(request)
  )
  def listManagedPoliciesInPermissionSet(
      request: ListManagedPoliciesInPermissionSetRequest
  ): ZStream[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly
  ] = ZStream.serviceWithStream(_.listManagedPoliciesInPermissionSet(request))
  def listManagedPoliciesInPermissionSetPaginated(
      request: ListManagedPoliciesInPermissionSetRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listManagedPoliciesInPermissionSetPaginated(request))
  def createPermissionSet(request: CreatePermissionSetRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.CreatePermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPermissionSet(request))
  def createAccountAssignment(request: CreateAccountAssignmentRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccountAssignment(request))
  def listInstances(request: ListInstancesRequest): ZStream[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listInstances(request))
  def listInstancesPaginated(request: ListInstancesRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstancesPaginated(request))
  def listAccountAssignmentCreationStatus(
      request: ListAccountAssignmentCreationStatusRequest
  ): ZStream[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccountAssignmentCreationStatus(request))
  def listAccountAssignmentCreationStatusPaginated(
      request: ListAccountAssignmentCreationStatusRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listAccountAssignmentCreationStatusPaginated(request))
  def updatePermissionSet(request: UpdatePermissionSetRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.UpdatePermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePermissionSet(request))
  def deleteInlinePolicyFromPermissionSet(
      request: DeleteInlinePolicyFromPermissionSetRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInlinePolicyFromPermissionSet(request))
  def getInlinePolicyForPermissionSet(
      request: GetInlinePolicyForPermissionSetRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInlinePolicyForPermissionSet(request))
  def attachManagedPolicyToPermissionSet(
      request: AttachManagedPolicyToPermissionSetRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachManagedPolicyToPermissionSet(request))
  def describeAccountAssignmentDeletionStatus(
      request: DescribeAccountAssignmentDeletionStatusRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAssignmentDeletionStatus(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteInstanceAccessControlAttributeConfiguration(
      request: DeleteInstanceAccessControlAttributeConfigurationRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.deleteInstanceAccessControlAttributeConfiguration(request)
  )
  def deletePermissionSet(request: DeletePermissionSetRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DeletePermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePermissionSet(request))
  def describeAccountAssignmentCreationStatus(
      request: DescribeAccountAssignmentCreationStatusRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAssignmentCreationStatus(request))
  def listPermissionSetProvisioningStatus(
      request: ListPermissionSetProvisioningStatusRequest
  ): ZStream[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
  ] = ZStream.serviceWithStream(_.listPermissionSetProvisioningStatus(request))
  def listPermissionSetProvisioningStatusPaginated(
      request: ListPermissionSetProvisioningStatusRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listPermissionSetProvisioningStatusPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def provisionPermissionSet(
      request: ProvisionPermissionSetRequest
  ): ZIO[zio.aws.ssoadmin.SsoAdmin, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.provisionPermissionSet(request))
  def listAccountsForProvisionedPermissionSet(
      request: ListAccountsForProvisionedPermissionSetRequest
  ): ZStream[zio.aws.ssoadmin.SsoAdmin, AwsError, AccountId] =
    ZStream.serviceWithStream(
      _.listAccountsForProvisionedPermissionSet(request)
    )
  def listAccountsForProvisionedPermissionSetPaginated(
      request: ListAccountsForProvisionedPermissionSetRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listAccountsForProvisionedPermissionSetPaginated(request)
  )
  def createInstanceAccessControlAttributeConfiguration(
      request: CreateInstanceAccessControlAttributeConfigurationRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.createInstanceAccessControlAttributeConfiguration(request)
  )
  def listPermissionSetsProvisionedToAccount(
      request: ListPermissionSetsProvisionedToAccountRequest
  ): ZStream[zio.aws.ssoadmin.SsoAdmin, AwsError, PermissionSetArn] =
    ZStream.serviceWithStream(_.listPermissionSetsProvisionedToAccount(request))
  def listPermissionSetsProvisionedToAccountPaginated(
      request: ListPermissionSetsProvisionedToAccountRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.listPermissionSetsProvisionedToAccountPaginated(request)
  )
  def putInlinePolicyToPermissionSet(
      request: PutInlinePolicyToPermissionSetRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putInlinePolicyToPermissionSet(request))
  def listAccountAssignments(request: ListAccountAssignmentsRequest): ZStream[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.AccountAssignment.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccountAssignments(request))
  def listAccountAssignmentsPaginated(
      request: ListAccountAssignmentsRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccountAssignmentsPaginated(request))
  def deleteAccountAssignment(request: DeleteAccountAssignmentRequest): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAccountAssignment(request))
  def updateInstanceAccessControlAttributeConfiguration(
      request: UpdateInstanceAccessControlAttributeConfigurationRequest
  ): ZIO[
    zio.aws.ssoadmin.SsoAdmin,
    AwsError,
    zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.updateInstanceAccessControlAttributeConfiguration(request)
  )
}
