package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  TargetId,
  PermissionSetArn,
  InstanceArn
}
import scala.jdk.CollectionConverters._
final case class ProvisionPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    targetId: Option[TargetId] = None,
    targetType: zio.aws.ssoadmin.model.ProvisionTargetType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest = {
    import ProvisionPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .targetType(targetType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ProvisionPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.ProvisionPermissionSetRequest.wrap(buildAwsValue())
}
object ProvisionPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ProvisionPermissionSetRequest =
      zio.aws.ssoadmin.model.ProvisionPermissionSetRequest(
        instanceArn,
        permissionSetArn,
        targetId.map(value => value),
        targetType
      )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def targetId: Option[TargetId]
    def targetType: zio.aws.ssoadmin.model.ProvisionTargetType
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getTargetType
        : ZIO[Any, Nothing, zio.aws.ssoadmin.model.ProvisionTargetType] =
      ZIO.succeed(targetType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.ProvisionPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val targetId: Option[TargetId] = scala
      .Option(impl.targetId())
      .map(value => zio.aws.ssoadmin.model.primitives.TargetId(value))
    override val targetType: zio.aws.ssoadmin.model.ProvisionTargetType =
      zio.aws.ssoadmin.model.ProvisionTargetType.wrap(impl.targetType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest
  ): zio.aws.ssoadmin.model.ProvisionPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
