package zio.aws.ssoadmin.model
import scala.jdk.CollectionConverters._
sealed trait ProvisioningStatus {
  def unwrap: software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus
}
object ProvisioningStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus
  ): zio.aws.ssoadmin.model.ProvisioningStatus = value match {
    case software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus.LATEST_PERMISSION_SET_PROVISIONED =>
      val r = LATEST_PERMISSION_SET_PROVISIONED
      r
    case software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus.LATEST_PERMISSION_SET_NOT_PROVISIONED =>
      val r = LATEST_PERMISSION_SET_NOT_PROVISIONED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssoadmin.model.ProvisioningStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus =
      software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object LATEST_PERMISSION_SET_PROVISIONED
      extends zio.aws.ssoadmin.model.ProvisioningStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus =
      software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus.LATEST_PERMISSION_SET_PROVISIONED
  }
  case object LATEST_PERMISSION_SET_NOT_PROVISIONED
      extends zio.aws.ssoadmin.model.ProvisioningStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus =
      software.amazon.awssdk.services.ssoadmin.model.ProvisioningStatus.LATEST_PERMISSION_SET_NOT_PROVISIONED
  }
}
