package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListPermissionSetProvisioningStatusResponse(
    permissionSetsProvisioningStatus: Option[
      Iterable[zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse = {
    import ListPermissionSetProvisioningStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
      .builder()
      .optionallyWith(
        permissionSetsProvisioningStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.permissionSetsProvisioningStatus)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
      .wrap(buildAwsValue())
}
object ListPermissionSetProvisioningStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse =
      zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse(
        permissionSetsProvisioningStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def permissionSetsProvisioningStatus: Option[List[
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
    ]]
    def nextToken: Option[Token]
    def getPermissionSetsProvisioningStatus: ZIO[Any, AwsError, List[
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "permissionSetsProvisioningStatus",
      permissionSetsProvisioningStatus
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
  ) extends zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly {
    override val permissionSetsProvisioningStatus: Option[List[
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
    ]] = scala
      .Option(impl.permissionSetsProvisioningStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
  ): zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly =
    new Wrapper(impl)
}
