package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePermissionSetResponse(
    permissionSet: Option[zio.aws.ssoadmin.model.PermissionSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse = {
    import DescribePermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse
      .builder()
      .optionallyWith(permissionSet.map(value => value.buildAwsValue()))(
        _.permissionSet
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.DescribePermissionSetResponse.wrap(buildAwsValue())
}
object DescribePermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.DescribePermissionSetResponse =
      zio.aws.ssoadmin.model.DescribePermissionSetResponse(
        permissionSet.map(value => value.asEditable)
      )
    def permissionSet: Option[zio.aws.ssoadmin.model.PermissionSet.ReadOnly]
    def getPermissionSet
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.PermissionSet.ReadOnly] =
      AwsError.unwrapOptionField("permissionSet", permissionSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse
  ) extends zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly {
    override val permissionSet
        : Option[zio.aws.ssoadmin.model.PermissionSet.ReadOnly] = scala
      .Option(impl.permissionSet())
      .map(value => zio.aws.ssoadmin.model.PermissionSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse
  ): zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly =
    new Wrapper(impl)
}
