package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{
  PrincipalId,
  PermissionSetArn,
  TargetId,
  InstanceArn
}
import scala.jdk.CollectionConverters._
final case class DeleteAccountAssignmentRequest(
    instanceArn: InstanceArn,
    targetId: TargetId,
    targetType: zio.aws.ssoadmin.model.TargetType,
    permissionSetArn: PermissionSetArn,
    principalType: zio.aws.ssoadmin.model.PrincipalType,
    principalId: PrincipalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest = {
    import DeleteAccountAssignmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .targetId(TargetId.unwrap(targetId): java.lang.String)
      .targetType(targetType.unwrap)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .principalType(principalType.unwrap)
      .principalId(PrincipalId.unwrap(principalId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DeleteAccountAssignmentRequest.ReadOnly =
    zio.aws.ssoadmin.model.DeleteAccountAssignmentRequest.wrap(buildAwsValue())
}
object DeleteAccountAssignmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.DeleteAccountAssignmentRequest =
      zio.aws.ssoadmin.model.DeleteAccountAssignmentRequest(
        instanceArn,
        targetId,
        targetType,
        permissionSetArn,
        principalType,
        principalId
      )
    def instanceArn: InstanceArn
    def targetId: TargetId
    def targetType: zio.aws.ssoadmin.model.TargetType
    def permissionSetArn: PermissionSetArn
    def principalType: zio.aws.ssoadmin.model.PrincipalType
    def principalId: PrincipalId
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getTargetId: ZIO[Any, Nothing, TargetId] = ZIO.succeed(targetId)
    def getTargetType: ZIO[Any, Nothing, zio.aws.ssoadmin.model.TargetType] =
      ZIO.succeed(targetType)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getPrincipalType
        : ZIO[Any, Nothing, zio.aws.ssoadmin.model.PrincipalType] =
      ZIO.succeed(principalType)
    def getPrincipalId: ZIO[Any, Nothing, PrincipalId] =
      ZIO.succeed(principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest
  ) extends zio.aws.ssoadmin.model.DeleteAccountAssignmentRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val targetId: TargetId =
      zio.aws.ssoadmin.model.primitives.TargetId(impl.targetId())
    override val targetType: zio.aws.ssoadmin.model.TargetType =
      zio.aws.ssoadmin.model.TargetType.wrap(impl.targetType())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val principalType: zio.aws.ssoadmin.model.PrincipalType =
      zio.aws.ssoadmin.model.PrincipalType.wrap(impl.principalType())
    override val principalId: PrincipalId =
      zio.aws.ssoadmin.model.primitives.PrincipalId(impl.principalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest
  ): zio.aws.ssoadmin.model.DeleteAccountAssignmentRequest.ReadOnly =
    new Wrapper(impl)
}
