package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.InstanceAccessControlAttributeConfigurationStatusReason
import scala.jdk.CollectionConverters._
final case class DescribeInstanceAccessControlAttributeConfigurationResponse(
    status: Option[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
    ] = None,
    statusReason: Option[
      InstanceAccessControlAttributeConfigurationStatusReason
    ] = None,
    instanceAccessControlAttributeConfiguration: Option[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse = {
    import DescribeInstanceAccessControlAttributeConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          InstanceAccessControlAttributeConfigurationStatusReason.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusReason)
      .optionallyWith(
        instanceAccessControlAttributeConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.instanceAccessControlAttributeConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly =
    zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceAccessControlAttributeConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse =
      zio.aws.ssoadmin.model
        .DescribeInstanceAccessControlAttributeConfigurationResponse(
          status.map(value => value),
          statusReason.map(value => value),
          instanceAccessControlAttributeConfiguration.map(value =>
            value.asEditable
          )
        )
    def status: Option[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
    ]
    def statusReason
        : Option[InstanceAccessControlAttributeConfigurationStatusReason]
    def instanceAccessControlAttributeConfiguration: Option[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    ]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[
      Any,
      AwsError,
      InstanceAccessControlAttributeConfigurationStatusReason
    ] = AwsError.unwrapOptionField("statusReason", statusReason)
    def getInstanceAccessControlAttributeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceAccessControlAttributeConfiguration",
      instanceAccessControlAttributeConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
  ) extends zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly {
    override val status: Option[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
    ] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
          .wrap(value)
      )
    override val statusReason
        : Option[InstanceAccessControlAttributeConfigurationStatusReason] =
      scala
        .Option(impl.statusReason())
        .map(value =>
          zio.aws.ssoadmin.model.primitives
            .InstanceAccessControlAttributeConfigurationStatusReason(value)
        )
    override val instanceAccessControlAttributeConfiguration: Option[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    ] = scala
      .Option(impl.instanceAccessControlAttributeConfiguration())
      .map(value =>
        zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
  ): zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
