package zio.aws.sso.model
import zio.prelude.data.Optional
import zio.aws.sso.model.primitives.{
  AccountIdType,
  AccessTokenType,
  MaxResultType,
  NextTokenType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAccountRolesRequest(
    nextToken: Optional[NextTokenType] = Optional.Absent,
    maxResults: Optional[MaxResultType] = Optional.Absent,
    accessToken: AccessTokenType,
    accountId: AccountIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountRolesRequest = {
    import ListAccountRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountRolesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResultType.unwrap(value): Integer)
      )(_.maxResults)
      .accessToken(AccessTokenType.unwrap(accessToken): java.lang.String)
      .accountId(AccountIdType.unwrap(accountId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.ListAccountRolesRequest.ReadOnly =
    zio.aws.sso.model.ListAccountRolesRequest.wrap(buildAwsValue())
}
object ListAccountRolesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountRolesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.ListAccountRolesRequest =
      zio.aws.sso.model.ListAccountRolesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        accessToken,
        accountId
      )
    def nextToken: Optional[NextTokenType]
    def maxResults: Optional[MaxResultType]
    def accessToken: AccessTokenType
    def accountId: AccountIdType
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAccessToken: ZIO[Any, Nothing, AccessTokenType] =
      ZIO.succeed(accessToken)
    def getAccountId: ZIO[Any, Nothing, AccountIdType] = ZIO.succeed(accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesRequest
  ) extends zio.aws.sso.model.ListAccountRolesRequest.ReadOnly {
    override val nextToken: Optional[NextTokenType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sso.model.primitives.NextTokenType(value))
    override val maxResults: Optional[MaxResultType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sso.model.primitives.MaxResultType(value))
    override val accessToken: AccessTokenType =
      zio.aws.sso.model.primitives.AccessTokenType(impl.accessToken())
    override val accountId: AccountIdType =
      zio.aws.sso.model.primitives.AccountIdType(impl.accountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesRequest
  ): zio.aws.sso.model.ListAccountRolesRequest.ReadOnly = new Wrapper(impl)
}
