package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sso.model.primitives.NextTokenType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccountRolesResponse(
    nextToken: Optional[NextTokenType] = Optional.Absent,
    roleList: Optional[Iterable[zio.aws.sso.model.RoleInfo]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountRolesResponse = {
    import ListAccountRolesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        roleList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roleList)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.ListAccountRolesResponse.ReadOnly =
    zio.aws.sso.model.ListAccountRolesResponse.wrap(buildAwsValue())
}
object ListAccountRolesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.ListAccountRolesResponse =
      zio.aws.sso.model.ListAccountRolesResponse(
        nextToken.map(value => value),
        roleList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextTokenType]
    def roleList: Optional[List[zio.aws.sso.model.RoleInfo.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRoleList
        : ZIO[Any, AwsError, List[zio.aws.sso.model.RoleInfo.ReadOnly]] =
      AwsError.unwrapOptionField("roleList", roleList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
  ) extends zio.aws.sso.model.ListAccountRolesResponse.ReadOnly {
    override val nextToken: Optional[NextTokenType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sso.model.primitives.NextTokenType(value))
    override val roleList: Optional[List[zio.aws.sso.model.RoleInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roleList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sso.model.RoleInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesResponse
  ): zio.aws.sso.model.ListAccountRolesResponse.ReadOnly = new Wrapper(impl)
}
