package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sso.model.primitives.{AccountIdType, RoleNameType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RoleInfo(
    roleName: Optional[RoleNameType] = Optional.Absent,
    accountId: Optional[AccountIdType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.RoleInfo = {
    import RoleInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.RoleInfo
      .builder()
      .optionallyWith(
        roleName.map(value => RoleNameType.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        accountId.map(value => AccountIdType.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.RoleInfo.ReadOnly =
    zio.aws.sso.model.RoleInfo.wrap(buildAwsValue())
}
object RoleInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sso.model.RoleInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.RoleInfo = zio.aws.sso.model
      .RoleInfo(roleName.map(value => value), accountId.map(value => value))
    def roleName: Optional[RoleNameType]
    def accountId: Optional[AccountIdType]
    def getRoleName: ZIO[Any, AwsError, RoleNameType] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getAccountId: ZIO[Any, AwsError, AccountIdType] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.RoleInfo
  ) extends zio.aws.sso.model.RoleInfo.ReadOnly {
    override val roleName: Optional[RoleNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.sso.model.primitives.RoleNameType(value))
    override val accountId: Optional[AccountIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.sso.model.primitives.AccountIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.RoleInfo
  ): zio.aws.sso.model.RoleInfo.ReadOnly = new Wrapper(impl)
}
