package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sso.model.primitives.NextTokenType
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccountsResponse(
    nextToken: Optional[NextTokenType] = Optional.Absent,
    accountList: Optional[Iterable[zio.aws.sso.model.AccountInfo]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountsResponse = {
    import ListAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        accountList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountList)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.ListAccountsResponse.ReadOnly =
    zio.aws.sso.model.ListAccountsResponse.wrap(buildAwsValue())
}
object ListAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.ListAccountsResponse =
      zio.aws.sso.model.ListAccountsResponse(
        nextToken.map(value => value),
        accountList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextTokenType]
    def accountList: Optional[List[zio.aws.sso.model.AccountInfo.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccountList
        : ZIO[Any, AwsError, List[zio.aws.sso.model.AccountInfo.ReadOnly]] =
      AwsError.unwrapOptionField("accountList", accountList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsResponse
  ) extends zio.aws.sso.model.ListAccountsResponse.ReadOnly {
    override val nextToken: Optional[NextTokenType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sso.model.primitives.NextTokenType(value))
    override val accountList
        : Optional[List[zio.aws.sso.model.AccountInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sso.model.AccountInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountsResponse
  ): zio.aws.sso.model.ListAccountsResponse.ReadOnly = new Wrapper(impl)
}
