package zio.aws.sso
import zio.mock.{Proxy, Mock}
import zio.aws.sso.model.{
  LogoutRequest,
  ListAccountsRequest,
  ListAccountRolesRequest,
  GetRoleCredentialsRequest
}
import zio.aws.sso.model.ListAccountsResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.sso.SsoAsyncClient
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object SsoMock extends Mock[Sso] {
  object GetRoleCredentials
      extends Effect[
        GetRoleCredentialsRequest,
        AwsError,
        zio.aws.sso.model.GetRoleCredentialsResponse.ReadOnly
      ]
  object ListAccountRoles
      extends Stream[
        ListAccountRolesRequest,
        AwsError,
        zio.aws.sso.model.RoleInfo.ReadOnly
      ]
  object ListAccountRolesPaginated
      extends Effect[
        ListAccountRolesRequest,
        AwsError,
        zio.aws.sso.model.ListAccountRolesResponse.ReadOnly
      ]
  object ListAccounts
      extends Stream[
        ListAccountsRequest,
        AwsError,
        zio.aws.sso.model.AccountInfo.ReadOnly
      ]
  object ListAccountsPaginated
      extends Effect[ListAccountsRequest, AwsError, ReadOnly]
  object Logout extends Effect[LogoutRequest, AwsError, Unit]
  val compose: URLayer[Proxy, Sso] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Sso] { rts =>
        zio.ZIO.succeed {
          new Sso {
            val api: SsoAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Sso = this
            def getRoleCredentials(request: GetRoleCredentialsRequest): IO[
              AwsError,
              zio.aws.sso.model.GetRoleCredentialsResponse.ReadOnly
            ] = proxy(GetRoleCredentials, request)
            def listAccountRoles(
                request: ListAccountRolesRequest
            ): ZStream[Any, AwsError, zio.aws.sso.model.RoleInfo.ReadOnly] =
              rts.unsafeRun(proxy(ListAccountRoles, request))
            def listAccountRolesPaginated(request: ListAccountRolesRequest): IO[
              AwsError,
              zio.aws.sso.model.ListAccountRolesResponse.ReadOnly
            ] = proxy(ListAccountRolesPaginated, request)
            def listAccounts(
                request: ListAccountsRequest
            ): ZStream[Any, AwsError, zio.aws.sso.model.AccountInfo.ReadOnly] =
              rts.unsafeRun(proxy(ListAccounts, request))
            def listAccountsPaginated(
                request: ListAccountsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListAccountsPaginated, request)
            def logout(request: LogoutRequest): IO[AwsError, Unit] =
              proxy(Logout, request)
          }
        }
      }
    }
  }
}
