package zio.aws.sso
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.sso.paginators.{
  ListAccountsPublisher,
  ListAccountRolesPublisher
}
import zio.aws.sso.model.{
  LogoutRequest,
  ListAccountsRequest,
  ListAccountRolesRequest,
  GetRoleCredentialsRequest
}
import zio.aws.sso.model.ListAccountsResponse.ReadOnly
import software.amazon.awssdk.services.sso.model.{
  AccountInfo,
  LogoutResponse,
  RoleInfo,
  ListAccountsResponse,
  GetRoleCredentialsResponse,
  ListAccountRolesResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.sso.{
  SsoAsyncClientBuilder,
  SsoAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Sso extends AspectSupport[Sso] {
  val api: SsoAsyncClient
  def getRoleCredentials(
      request: GetRoleCredentialsRequest
  ): IO[AwsError, zio.aws.sso.model.GetRoleCredentialsResponse.ReadOnly]
  def listAccountRoles(
      request: ListAccountRolesRequest
  ): ZStream[Any, AwsError, zio.aws.sso.model.RoleInfo.ReadOnly]
  def listAccountRolesPaginated(
      request: ListAccountRolesRequest
  ): IO[AwsError, zio.aws.sso.model.ListAccountRolesResponse.ReadOnly]
  def listAccounts(
      request: ListAccountsRequest
  ): ZStream[Any, AwsError, zio.aws.sso.model.AccountInfo.ReadOnly]
  def listAccountsPaginated(
      request: ListAccountsRequest
  ): IO[AwsError, ReadOnly]
  def logout(request: LogoutRequest): IO[AwsError, Unit]
}
object Sso {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Sso] = customized(identity)
  def customized(
      customization: SsoAsyncClientBuilder => SsoAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Sso] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: SsoAsyncClientBuilder => SsoAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Sso] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = SsoAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[SsoAsyncClient, SsoAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[SsoAsyncClient, SsoAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new SsoImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SsoImpl[R](
      override val api: SsoAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Sso
      with AwsServiceBase[R] {
    override val serviceName: String = "Sso"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SsoImpl[R1] = new SsoImpl(api, newAspect, r)
    def getRoleCredentials(
        request: GetRoleCredentialsRequest
    ): IO[AwsError, zio.aws.sso.model.GetRoleCredentialsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest,
        GetRoleCredentialsResponse
      ]("getRoleCredentials", api.getRoleCredentials)(request.buildAwsValue())
        .map(zio.aws.sso.model.GetRoleCredentialsResponse.wrap)
        .provideEnvironment(r)
    def listAccountRoles(
        request: ListAccountRolesRequest
    ): ZStream[Any, AwsError, zio.aws.sso.model.RoleInfo.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.sso.model.ListAccountRolesRequest,
        RoleInfo,
        ListAccountRolesPublisher
      ]("listAccountRoles", api.listAccountRolesPaginator, _.roleList())(
        request.buildAwsValue()
      ).map(item => zio.aws.sso.model.RoleInfo.wrap(item)).provideEnvironment(r)
    def listAccountRolesPaginated(
        request: ListAccountRolesRequest
    ): IO[AwsError, zio.aws.sso.model.ListAccountRolesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sso.model.ListAccountRolesRequest,
        ListAccountRolesResponse
      ]("listAccountRoles", api.listAccountRoles)(request.buildAwsValue())
        .map(zio.aws.sso.model.ListAccountRolesResponse.wrap)
        .provideEnvironment(r)
    def listAccounts(
        request: ListAccountsRequest
    ): ZStream[Any, AwsError, zio.aws.sso.model.AccountInfo.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.sso.model.ListAccountsRequest,
        AccountInfo,
        ListAccountsPublisher
      ]("listAccounts", api.listAccountsPaginator, _.accountList())(
        request.buildAwsValue()
      ).map(item => zio.aws.sso.model.AccountInfo.wrap(item))
        .provideEnvironment(r)
    def listAccountsPaginated(
        request: ListAccountsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.sso.model.ListAccountsRequest,
      ListAccountsResponse
    ]("listAccounts", api.listAccounts)(request.buildAwsValue())
      .map(zio.aws.sso.model.ListAccountsResponse.wrap)
      .provideEnvironment(r)
    def logout(request: LogoutRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.sso.model.LogoutRequest,
        LogoutResponse
      ]("logout", api.logout)(request.buildAwsValue()).unit
        .provideEnvironment(r)
  }
  def getRoleCredentials(request: GetRoleCredentialsRequest): ZIO[
    zio.aws.sso.Sso,
    AwsError,
    zio.aws.sso.model.GetRoleCredentialsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoleCredentials(request))
  def listAccountRoles(
      request: ListAccountRolesRequest
  ): ZStream[zio.aws.sso.Sso, AwsError, zio.aws.sso.model.RoleInfo.ReadOnly] =
    ZStream.serviceWithStream(_.listAccountRoles(request))
  def listAccountRolesPaginated(request: ListAccountRolesRequest): ZIO[
    zio.aws.sso.Sso,
    AwsError,
    zio.aws.sso.model.ListAccountRolesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccountRolesPaginated(request))
  def listAccounts(request: ListAccountsRequest): ZStream[
    zio.aws.sso.Sso,
    AwsError,
    zio.aws.sso.model.AccountInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccounts(request))
  def listAccountsPaginated(
      request: ListAccountsRequest
  ): ZIO[zio.aws.sso.Sso, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listAccountsPaginated(request))
  def logout(request: LogoutRequest): ZIO[zio.aws.sso.Sso, AwsError, Unit] =
    ZIO.serviceWithZIO(_.logout(request))
}
