package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sso.model.primitives.AccessTokenType
import scala.jdk.CollectionConverters._
final case class LogoutRequest(accessToken: AccessTokenType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.LogoutRequest = {
    import LogoutRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.LogoutRequest
      .builder()
      .accessToken(AccessTokenType.unwrap(accessToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.LogoutRequest.ReadOnly =
    zio.aws.sso.model.LogoutRequest.wrap(buildAwsValue())
}
object LogoutRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sso.model.LogoutRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.LogoutRequest =
      zio.aws.sso.model.LogoutRequest(accessToken)
    def accessToken: AccessTokenType
    def getAccessToken: ZIO[Any, Nothing, AccessTokenType] =
      ZIO.succeed(accessToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.LogoutRequest
  ) extends zio.aws.sso.model.LogoutRequest.ReadOnly {
    override val accessToken: AccessTokenType =
      zio.aws.sso.model.primitives.AccessTokenType(impl.accessToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.LogoutRequest
  ): zio.aws.sso.model.LogoutRequest.ReadOnly = new Wrapper(impl)
}
