package zio.aws.sso.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sso.model.primitives.{
  EmailAddressType,
  AccountNameType,
  AccountIdType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountInfo(
    accountId: Optional[AccountIdType] = Optional.Absent,
    accountName: Optional[AccountNameType] = Optional.Absent,
    emailAddress: Optional[EmailAddressType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.AccountInfo = {
    import AccountInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.AccountInfo
      .builder()
      .optionallyWith(
        accountId.map(value => AccountIdType.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        accountName.map(value =>
          AccountNameType.unwrap(value): java.lang.String
        )
      )(_.accountName)
      .optionallyWith(
        emailAddress.map(value =>
          EmailAddressType.unwrap(value): java.lang.String
        )
      )(_.emailAddress)
      .build()
  }
  def asReadOnly: zio.aws.sso.model.AccountInfo.ReadOnly =
    zio.aws.sso.model.AccountInfo.wrap(buildAwsValue())
}
object AccountInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sso.model.AccountInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sso.model.AccountInfo =
      zio.aws.sso.model.AccountInfo(
        accountId.map(value => value),
        accountName.map(value => value),
        emailAddress.map(value => value)
      )
    def accountId: Optional[AccountIdType]
    def accountName: Optional[AccountNameType]
    def emailAddress: Optional[EmailAddressType]
    def getAccountId: ZIO[Any, AwsError, AccountIdType] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAccountName: ZIO[Any, AwsError, AccountNameType] =
      AwsError.unwrapOptionField("accountName", accountName)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddressType] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.AccountInfo
  ) extends zio.aws.sso.model.AccountInfo.ReadOnly {
    override val accountId: Optional[AccountIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.sso.model.primitives.AccountIdType(value))
    override val accountName: Optional[AccountNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.accountName())
      .map(value => zio.aws.sso.model.primitives.AccountNameType(value))
    override val emailAddress: Optional[EmailAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailAddress())
        .map(value => zio.aws.sso.model.primitives.EmailAddressType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.AccountInfo
  ): zio.aws.sso.model.AccountInfo.ReadOnly = new Wrapper(impl)
}
